/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.behaviours.interfaces.BehaviourSapling;
import org.betterx.bclib.blocks.FeatureSaplingBlock;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.interfaces.SurvivesOnNetherrack;
import org.betterx.betternether.registry.features.configured.NetherTrees;

public class BlockStalagnateSeed
extends FeatureSaplingBlock
implements BonemealableBlock,
SurvivesOnNetherrack,
BehaviourSapling {
    public static final int MAX_SEARCH_LENGTH = 25;
    public static final int MIN_LENGTH = 3;
    protected static final VoxelShape SHAPE_TOP = Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");

    public BlockStalagnateSeed() {
        super(state -> BlockStalagnateSeed.growsDownward(state) ? NetherTrees.STALAGNATE_DOWN : NetherTrees.STALAGNATE);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{TOP});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        if (ctx.m_43719_() == Direction.DOWN) {
            return blockState;
        }
        if (ctx.m_43719_() == Direction.UP) {
            return (BlockState)blockState.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BlockStalagnateSeed.growsDownward(state) ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    private static boolean growsDownward(BlockState state) {
        return (Boolean)state.m_61143_((Property)TOP);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        if (super.m_214167_(world, random, pos, state)) {
            if (BlockStalagnateSeed.growsDownward(state)) {
                return BlocksHelper.downRay((LevelAccessor)world, pos, 3) > 0;
            }
            return BlocksHelper.upRay((LevelAccessor)world, pos, 3) > 0;
        }
        return false;
    }

    protected boolean m_6266_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.isSurvivable(blockState);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.m_61148_().get((Object)TOP) == null) {
            return false;
        }
        BlockPos target = BlockStalagnateSeed.growsDownward(blockState) ? blockPos.m_7494_() : blockPos.m_7495_();
        return this.m_6266_(levelReader.m_8055_(target), (BlockGetter)levelReader, target);
    }

    protected BCLConfigureFeature getConfiguredFeature(BlockState state) {
        if (BlockStalagnateSeed.growsDownward(state)) {
            return NetherTrees.STALAGNATE_DOWN;
        }
        return NetherTrees.STALAGNATE;
    }
}

